	; public domain tool by Eric Auer for FreeDOS installation
	; to create the binary: nasm -o iniadd.com iniadd.asm
	; you can find NASM at http://nasm.sourceforge.net/

	; Usage: INIADD filename string1 string2
	; Filename and string1 must not contain spaces or wildcards.
	; If String1 is not found (case does not matter for A-Z),
	; then String2 and CRLF are added to file filename.
	; If needed, file write protection is overridden, as if
	; you had used ATTRIB. If there is no CRLF at the end of
	; the file, CRLF is inserted before String2 when String2
	; is added. Example:
	; iniadd c:\boot.ini freedos c:\freedos.bss="FreeDOS"

	org 100h

start:	cld
	mov si,81h	; command line arguments
	call skipws
	jc help		; line should not end here
	mov [cs:fnptr],ax	; store file name pointer
	mov si,ax
findws:	lodsb		; scan to end of filename
	cmp al,' '
	jz foundws
	cmp al,9
	jz foundws
	cmp al,13	; line should not end here
	ja findws


help:	mov dx,helpmsg
	mov ah,9	; show string
	int 21h		; DOS
	mov ax,4cffh	; exit with errorlevel 255
	int 21h		; DOS

; -------------

skipws:	lodsb		; skip leading whitespace in string at DS:SI
	cmp al,' '
	jz skipws
	cmp al,9	; tab
	jz skipws
	cmp al,13	; carriage return
	jbe eline
	mov ax,si
	dec ax
	clc
	ret		; AX now points to first non-whitespace char
eline:	stc
	ret		; line ended while scanning

; -------------

foundws:
	mov byte [si-1],0	; add string terminator
	call skipws
	jc help		; line should not end here
	mov si,ax
	mov [cs:srchptr],ax	; store search string pointer
scanss:	lodsb		; check search string
	cmp al,'z'
	ja scanss
	cmp al,'a'
	jb noup
	sub al,'a'-'A'	; upcase char
	mov [si-1],al
noup:	cmp al,' '
	jz srchok
	cmp al,9
	jz srchok
	cmp al,13	; line should not end here
	jbe help
	jmp short scanss

srchok:	mov ax,si	; first char after search string
	dec ax
	sub ax,[cs:srchptr]	; calculate length of search string
	mov [cs:srchlen],ax
	call skipws
	jc help		; line should not end here
	mov [cs:txtptr],ax
	mov si,ax
getend:	lodsb
	cmp al,9
	jz getend
	cmp al,13
	ja getend
	mov word [si-1],0a0dh	; patch in CR followed by LF
	; ** All command line argument parsing done **

; -------------

	mov dx,[cs:fnptr]	; file name
	mov ax,3d00h		; open for read
	mov cl,37h
	int 21h			; DOS
	jnc okopen		; failed?
	mov dx,openmsg
	jmp errexit

okopen:	mov bx,ax		; handle (for function 3f)

	mov ah,3fh		; read from file
	mov dx,buf		; buffer position
	mov cx,sp		; calculate buffer size
	sub cx,dx
	sub cx,4096		; reserved for stack
	push cx
	int 21h			; DOS
	pop cx
	jc rderr
	cmp cx,ax		; buffer bigger than file?
	jnb okread		; else ("jbe rderr") we have a problem
rderr:	mov dx,readmsg

errexit:
	mov ah,9		; show message
	int 21h			; DOS
	mov ax,4cfeh		; exit with errorlevel 254
	int 21h			; DOS

okread:	cmp ax,2		; file too short?
	jb rderr
	mov [filelen],ax	; store file size
	mov ah,3eh		; close file (handle still BX)
	int 21h			; DOS

	mov si,buf-2
	add si,[cs:filelen]	; point to last 2 file bytes
	mov ax,[si]
	cmp ax,0d0ah		; LF CR found?
	jz okcrlf
	cmp ax,0a0dh		; CR LF found?
	jz okcrlf
	mov dx,crlfmsg
	mov ah,9		; show message
	int 21h			; DOS
	jmp short nocrlf

okcrlf:	mov byte [hascrlf],1	; remember that CR LF is already there
nocrlf:
	
	mov si,buf		; search in here
	mov di,[cs:srchptr]	; search that
	mov cx,buf
	sub cx,[cs:srchlen]
	add cx,[cs:filelen]	; find last useful match pointer
	cmp cx,buf
	jb notfound		; file too short to contain string

finds:	cmp si,cx
	jae notfound		; did not find string
	mov ax,[si]		; in buffer
finds2:	inc si
	xor ax,[di]		; in search string
	test ax,0dfdfh		; simple "almost case insensitive" compare
	jnz finds		; keep scanning fast until rough match found

	dec si			; prepare for slow full comparison
	push si			; "simple" case insensitive string match
	push di
	push bx
	push cx
	xor bx,bx
	mov cx,[cs:srchlen]
smatch:	mov al,[si+bx]		; in buffer
	cmp al,'z'
	ja noup2
	cmp al,'a'
	jb noup2
	sub al,'a'-'A'		; upcase char
noup2:	cmp al,[di+bx]		; in search string
	jnz nmatch
	inc bx			; advance pointers
	loop smatch
nmatch: xor ax,ax		; to get conditional finds2 jump right
	or cx,cx		; zero if strings matched
	pop cx
	pop bx
	pop di
	pop si

	jnz finds2		; keep searching (and advance pointer)
	; ** PHEW! We case-insensitively found the search string **

found:	mov dx,foundmsg
	mov ah,9		; show message
	int 21h			; DOS
	mov ax,4c00h		; exit with errorlevel 0
	int 21h			; DOS

; -------------

notfound:
	mov dx,notfoundmsg
	mov ah,9		; show message
	int 21h			; DOS

	mov dx,[cs:fnptr]	; file name pointer
	mov ax,4300h		; get file attributes
	int 21h			; DOS
	jnc okattr
erratt:	mov dx,attrmsg
	jmp errexit
okattr:	test cl,7		; 4 system 2 hidden 1 readonly
	jz okatt2
	mov [fattr],cx
	mov dx,achangemsg
	mov ah,9		; show message
	int 21h			; DOS

	mov dx,[cs:fnptr]	; file name pointer
	mov ax,4301h		; set file attributes
	mov cx,[cs:fattr]	; file attributes (will override them)
	and cl,0f8h		; reset system / hidden / readonly flags
	int 21h			; DOS
errat2:	jc erratt

okatt2:	xor cx,cx
	mov si,[cs:txtptr]
slen:	lodsb
	inc cx
	cmp al,10		; LF?
	jnz slen		; count text size
	; CX is now text size including the final LF
	
	mov al,[cs:hascrlf]	; file already ending in CR LF?
	or al,al
	jnz skipadd
	mov di,[cs:txtptr]
	sub di,2		; add in front of to-be-inserted-text...
	add cx,2		; ...so text will be longer...
	mov word [di],0a0dh	; patch in CR LF (over end of search string)
	mov [cs:txtptr],di
skipadd:

; -------------

	push cx			; store insertion size

	mov dx,[cs:fnptr]	; file name
	mov ax,3d02h		; open for write
	mov cl,37h
	int 21h			; DOS
	jnc okop2		; failed?
	mov dx,openmsg
	jmp errexit

okop2:	mov bx,ax		; handle (for functions 3f and 42)
	mov ax,4202h		; seek from end
	xor cx,cx		; high word of seek offset
	xor dx,dx		; low word of seek offset
	int 21h			; DOS
	jnc oksee2
	mov dx,seekmsg
	jmp errexit

oksee2:	pop cx			; fetch insertion size

	mov ah,40h		; write to file (handle still BX)
	mov dx,[cs:txtptr]	; pointer to data to be written
	int 21h			; DOS
	jnc okwrit
	mov dx,writemsg
	jmp errexit

okwrit:	mov ah,3eh		; close file (handle still BX)
	int 21h			; DOS (failure ignored)

; -------------

	mov dx,[cs:fnptr]	; file name pointer
	mov ax,4301h		; set file attributes
	mov cx,[cs:fattr]	; file attributes (restore them)
	test cl,7		; anything interesting?
	jz norest		; else no need to restore
	int 21h			; DOS
	jnc norest
	mov dx,attrmsg
	jmp errexit

norest:	mov dx,addedmsg
	mov ah,9		; show message
	int 21h
	mov ax,4c01h		; exit with errorlevel 1
	int 21h			; DOS

; -------------

fnptr	dw 0	; pointer to filename ASCIIZ string
srchptr	dw 0	; pointer to (normalized, unterminated) search string
srchlen	dw 0	; size of search string
txtptr	dw 0	; pointer to user string (0a (LF) terminated)
filelen	dw 0	; size of file, limited to 60k

fattr	dw 0	; original file attributes
hascrlf	db 0	; whether file already ends in CR LF

; -------------

openmsg:	db "ERROR: Could not open file.",13,10,"$"
readmsg:	db "ERROR: Could not read entire file.",13,10,"$"
attrmsg:	db "ERROR: Could not process file attributes.",13,10,"$"
seekmsg:	db "ERROR: Could not seek to end of file.",13,10,"$"
writemsg:	db "ERROR: Could not add text line to file.",13,10,"$"

crlfmsg:	db "INFO: File had no line break at the end yet.",13,10,"$"
foundmsg:	db "File already contains search string.",13,10,"$"
notfoundmsg:	db "File did not yet contain search string.",13,10,"$"
achangemsg:	db "INFO: File is hidden, system or readonly.",13,10,"$"
addedmsg:	db "Text line added to file.",13,10,"$"

helpmsg:
	db "Public Domain FreeDOS INIADD tool by Eric Auer 2004",13,10
	db "Usage: INIADD file searchstring some text",13,10
	db 13,10
	db "If SEARCHSTRING is not found in (max 60k big) FILE, then SOME",13,10
	db "TEXT is added to FILE. If needed, the read only attribute",13,10
	db "is temporarily removed from FILE for that. INIADD makes sure",13,10
	db "that there are line breaks before and after SOME TEXT.",13,10
	db "Case for A-Z is ignored in SEARCHSTRING. No wildcards.",13,10
	db 13,10
	db "Errorlevels: 254 access error, 255 syntax error,",13,10
	db "0 SEARCHSTRING found in file, 1 SOME TEXT added to file.",13,10
	db "$"

	align 16
buf:	; buffer for file contents

	; Errorlevel 255 syntax error, 254 file processing error
	; 0 search string found in file
	; 1 search string not found in file: some text added to file
