; RUNTIME by Eric Auer 2007 - measures running time :-)
; License: public domain. have fun! (based on CALLVER)
; Compile with nasm -o runtime.com runtime.asm
; Run as: RUNTIME program arguments
; Uses COUNTRY settings and LANG and COMSPEC variables.

	org 100h
start:	jmp setup	; jump to the part which does not stay in RAM


	; EXECUTE APP DS:DX
runit:	mov sp,stack	; not using cs:80h..cs:0ffh, need to preserve that
	mov bx,sp
	add bx,4+15	; round up
	mov cl,4
	shr bx,cl
	push es
	mov ax,cs
	mov es,ax
	mov ah,4ah	; resize memory block on ES to minimum
	int 21h		; (must keep PSP and environment, of course)
	mov ax,40h	; BIOS data segment
	mov es,ax
	pushf
	cli
	mov ax,[es:6ch]	; fetch timer tick count
	mov bx,[es:6eh]
	popf
	pop es		; (AX and BX got changed)
	mov [cs:time1],ax
	mov [cs:time1+2],bx

	mov ax,cs
	mov [cs:exetab+4],ax
	mov [cs:exetab+8],ax
	mov [cs:exetab+12],ax

	mov ax,4b00h	; execute program
	mov bx,cs
	mov es,bx	; ds:dx - executable file name (from runit-caller)
	mov bx,exetab	; es:bx - parameter block
	int 21h


done:	cli		; return from INT 21.4B00, all regs may be changed
	mov ax,cs
	mov ss,ax
	mov sp,stack	; (or use CS:0xfc ...)
	sti
	mov al,-1
	jc leaveit	; did exec itself fail?
	mov ah,4dh	; get errorlevel in AL
	int 21h		; discarded in AH: exit type, which is 0 normal,
			; 1 ctrl-c, 2 critical error, 3 TSR
leaveit:
	push ax
	mov ax,40h	; BIOS data segment
	mov es,ax
	mov ax,[es:6ch]	; get current timer tick count again
	mov dx,[es:6eh]
	sub ax,[cs:time1]
	sbb dx,[cs:time1+2]
	mov cx,cs
	mov ds,cx
	mov es,cx
	cmp dx,24
	jb oktime	; more than ca 24 hours: implausible, wrap?
	neg ax
	neg dx
	cmp dx,24
	jb oktime
	xor ax,ax	; if still not okay, show 00:00.00
	xor dx,dx
oktime:	mov bx,ax	; very manual "multiply by 10" follows
	mov cx,dx
	add ax,ax	; n*2
	adc dx,dx
	add ax,ax	; n*2*2
	adc dx,dx
	add ax,bx	; (n*2*2) + n
	adc dx,cx
	add ax,ax	; ((n*2*2)+n)*2
	adc dx,dx
	mov cx,182	; 18.2 ticks per second...
	div cx
	mov [seconds],ax
	mov ax,dx	; fraction
	xor dx,dx
	mov bx,55	; 5.5 milliseconds per 1/10th tick
	mul bx		; result: 0..9955 * 0.1 msec
	add ax,50	; round to next 1/100th second
	mov bx,100
	div bx
	cmp ax,100
	jnz nowrap
	dec ax
nowrap: mov [hund],ax	; 1/100ths


showtime:
	mov ax,[seconds]
	xor dx,dx
	mov bx,3600	; find hours
	mov cx,0	; flag: hours potentially 0
	div bx
	or ax,ax
	jz nohour
	call showal
	mov al,[cs:timesep]	; for example :
	call tty
	mov cx,1	; flag: hours not 0
nohour:	mov ax,dx	; remainder: minutes, secs
	xor dx,dx
	mov bx,60
	div bx
	or ax,ax	; if minutes > 0 or...
	jnz yesmin
	or cx,cx	; ...if hours > 0 then show minutes
	jz nomin
yesmin:	mov cx,1	; flag: hours or minutes not 0
	call showal
	mov al,[cs:timesep]	; for example :
	call tty
nomin:	mov ax,dx	; remainder: seconds
	call showal
	mov al,[cs:decsep]	; for example .
	call tty
	mov ax,[hund]
	call showal
	mov dx,[timemsg1]
	or cx,cx	; if at least 1 minute, adjust message
	jz dosec	; else use message "... seconds elapsed"
	mov dx,[timemsg2]	; do not mention "seconds"
dosec:	mov ah,9
	int 21h
	pop ax
	mov ah,4ch	; exit, returning errorlevel
	int 21h


tty:	push dx		; output char AL to stdout, destroys AX
	mov ah,2
	mov dl,al
	int 21h
	pop dx
	ret


showal:	push ax		; show binary value in AL as 2 digit decimal
	push dx
	mov ah,0
	mov dl,10
	div dl		; AL, remainder AH
;	or al,al
;	jz smallal
	add al,'0'
	push ax
	call tty	; high digit
	pop ax
; smallal:
	mov al,ah
	add al,'0'	; low digit
	call tty
	pop dx
	pop ax
	ret


	; PS: exectab is processed by patchPSP and others in FreeDOS...
exetab:	dw 0		; use caller environment segment
	dw 80h		; pointer to "arguments" in PSP segment of callver
	dw 0		; will be PSP segment of callver
	dw 5ch		; 1st FCB: use the one of callver (?)
			; looks as if offset is -1 here, no FCBs are copied
	dw 0		; ... segment
	dw 6ch		; 2nd FCB ...
	dw 0

time1:	dd 0		; original int 21h vector
hund:	dw 0		; 1/100ths
seconds:
	dw 0		; seconds, max ca 3600*24
timesep	db ':'		; separator between hours, minutes, seconds
decsep	db '.'		; separator between seconds, hundreths

	; configure DEFAULT LANGuage here
timemsg1	dw en_1	; timemessage
timemsg2	dw en_2	; timemessage2
hellomsg	dw en_3	; hellomessage
cspecmsg	dw en_4	; cspecerrormessage


	; Note that we have to take care not to overwrite the time-
	; message and timemessage2 that we use, though...
%if 0
timemessage:
	db " seconds"
timemessage2:
	db " elapsed",13,10,"$"

hellomessage:
	db "RUNTIME is free public domain software by Eric Auer 2007",13,10
	db "Usage: RUNTIME your_program [your_options]",13,10
	db "Shows how long your_program ran, max 1 day (23$"

cspecerrormessage:
	db "COMSPEC not found",13,10,"$"
%endif

patchm	db ":59:59.99)",13,10,"$" ; patch message here


	; format: transtable is array of structures
	; db language_id[2] (0,0 marks end of table)
	; dw string_pointers[4]
	; string ($-terminated strings, 2nd not terminated!) meanings:
	; 1. " seconds" 2. " elapsed", 3. help message and
	; 4. "COMSPEC not found"
%include "runt_inc.asm"	; ### translated messages ###

comarg:	db " /c "	; 4 bytes fixed size

badlangmessage:
	db "Please send a translation for LANG="
badlang	db "?? to eric (at-sign) coli.uni-sb.de",13,10,"$"


setlang:		; set strings for language AX (destroys SI, AX)
	push ds
	push cs
	pop ds
	mov si,transtable	; offset
	and ax,0dfdfh	; upcase
langtest:
	cmp ax,[si]
	jz langfound
	cmp word [si], byte 0
	jz nolangfound
	add si,10	; 2 chars plus 4 words per entry
	jmp short langtest
langfound:
	mov ax,[si+2]
	mov [timemsg1],ax
	mov ax,[si+4]
	mov [timemsg2],ax
	mov ax,[si+6]
	mov [hellomsg],ax
	mov ax,[si+8]
	mov [cspecmsg],ax
	pop ds
	clc
	ret
nolangfound:
	pop ds
	stc
	ret


setup:		; ENTRY POINT
	mov byte [ctry+0x0d],':'
	mov byte [ctry+0x09],'.'
	mov ax,0x3800	; get current country information (dos 2.11+)
	mov dx,ctry	; offset of buffer in DS - stack not in use
	int 0x21	; (stack will be activated as stack later)
	jc nocountry	; leave our defaults active on error
	mov al,[ctry+0x0d]	; time separator, default ':'
	mov [timesep],al
	mov [patchm],al		; also update message
	mov [patchm+3],al	; ... at two places
	mov al,[ctry+0x09]	; decimal separator
	mov [decsep],al
	mov [patchm+6],al	; also update message
nocountry:


environment1:	; LANG VARIABLE
	mov ax,[ds:2ch]	; get environment segment from PSP
	mov ds,ax
	xor si,si
findlang:
	lodsw
	and ax,0dfdfh	; upcase
	cmp ax,"LA"
	jnz skipa0
	lodsw
	and ax,0dfdfh	; upcase
	cmp ax,"NG"
	jnz skipa0
	lodsb
	cmp al,"="
	jnz skipa0
	lodsw		; only check first 2 chars of LANG
	push ax
	call setlang	; try to set language
	pop ax
	jnc langok
%if 1
	cmp al,' '	; show error if no translation
	jnb npad1
	mov ax,"  "
npad1:	cmp ah,' '
	jnb npad2
	mov ah,' '
npad2:	push ds
	mov [cs:badlang],ax
	mov ax,cs
	mov ds,ax
	mov dx,badlangmessage	; "?? is not a supported language"
	mov ah,9
	int 21h
	pop ds
%endif
langok:	jmp short allenv

skipa0:
	lodsb
	or al,al
	jnz skipa0	; skip until 0 byte
	cmp [ds:si],al	; next byte is 0, too?
	jz allenv	; bad luck, no LANG found
	jmp findlang	; try next env variable


allenv:	mov ax,cs
	mov ds,ax


commandline:	; COMMAND LINE ARGUMENTS / OPTIONS
	cld
	mov si,0x80	; argument length
	lodsb		; get size
	cmp al,1	; at least something
	jnb getarg
nusage:	jmp usage

getarg:	lodsb
	cmp al,' '	; skip spaces
	jz getarg
	cmp al,13	; end marker?
	jbe nusage	; error: need at least 1 argument, show help
	cmp al,'/'	; first char of arg "/" -> assume user tries /option
	jz nusage	; no options supported, show help
	cmp al,'-'	; first char of arg "-" -> assume user tries -option
	jz nusage	; no options supported, show help
	cmp al,'?'	; first char of arg "?' -> maybe user wants help?
	jz nusage	; show help

	sub si,4+1	; point to 4 before program name now
	mov di,si
	dec di		; room for length byte
	mov [exetab+2],di	; arguments to command.com start here
	inc di
	mov si,comarg	; " /c " (4 chars)
	movsw
	movsw		; copied the string before the buffer now

	mov ah,4	; already have 4 chars
	mov si,di
argcnt:	lodsb
	inc ah
	cmp al,13	; eof marker?
	ja argcnt
	dec ah		; do not count eof marker
	; ... could replace eof marker by some other value here ...
	mov di,[exetab+2]	; "command tail" including length byte
	mov [di],ah	; store length


environment2:	; COMSPEC VARIABLE
	mov ax,[ds:2ch]	; get environment segment from PSP
	mov ds,ax
	xor si,si
findcomspec:
	lodsw
	and ax,0dfdfh	; upcase
	cmp ax,"CO"
	jnz skiparg
	lodsw
	and ax,0dfdfh	; upcase
	cmp ax,"MS"
	jnz skiparg
	lodsw
	and ax,0dfdfh	; upcase
	cmp ax,"PE"
	jnz skiparg
	lodsw
	and al,0dfh	; upcase (only the last "c" of "comspec"...)
	cmp ax,"C="
	jnz skiparg

gotcomspec:
	mov dx,si	; ds:dx pointer to executable file name of shell
	; mov ds,ds	; note that DS is NOT equal to CS here!
	jmp runit	; finally, RUN "%COMSPEC% /C program arguments"


skiparg:
	lodsb
	or al,al
	jnz skiparg	; skip until 0 byte
	cmp [ds:si],al	; next byte is 0, too?
	jz cspecerr	; bad luck, no COMSPEC found
	jmp findcomspec	; try next env variable


cspecerr:
	mov dx,[cspecmsg]
	jmp short usage2

usage:	mov dx,[hellomsg]
	mov ax,cs
	mov ds,ax
	mov ah,9	; show string
	int 21h
	mov dx,patchm	; offset of the common part 2 of the help
usage2:	mov ax,cs
	mov ds,ax
	mov ah,9	; show string
	int 21h
	mov ax,4cffh	; report usage error and exit
	int 21h


	align 4
ctry:			; COUNTRY setting buffer (used before stack)
	; this is the end of the stack, it grows towards setup...
stack:	dd 0		; stack can overwrite setup and hellomessage!

