	; simple computer lock. type right password to exit...
	org 100h
	; int 1b called by int 9, usually sets a flag in DOS
	; int 23 dos break handler: clc retf +2 or iret to ignore
start:	push es
	mov ax,351bh
	int 21h		; get int 1b
	mov [cs:old1b],bx
	mov [cs:old1b+2],es
	mov ax,3523h
	int 21h		; get int 23
	mov [cs:old23],bx
	mov [cs:old23+2],es
	pop es
	mov dx,int1b
	mov ax,251bh
	int 21h		; hook int 1b
	mov dx,int23
	mov ax,2523h
	int 21h		; hook int 23

	mov si,81h	; command line
	mov di,si
	cld
	cmp byte [cs:si],13	; no arguments?
	jz help
preloop:		; copy argument, upcase it, remove spaces
	lodsb
	cmp al,13	; end?
	jz predone
	cmp al,'?'	; questionmark triggers help screen everywhere
	jz help
	cmp al,' '
	jz preloop
	cmp al,9	; tab?
	jz preloop
	cmp al,'a'	; boring case insensitivity for 7 bit ASCII
	jb ucase2	; feel free to add NLS international upcasing
	cmp al,'z'
	ja ucase2
	sub al,'a'-'A'
ucase2:	stosb
	jmp short preloop

help:	mov dx,helpmsg
	mov ah,9
	int 21h		; show help message
	jmp keyokay

predone:
	mov al,0	; terminate string
	stosb
	;
	call clearscreen

nexttry:
	mov dx,prompt
pat:	cmp dx,reprompt
	jnz first
	;
	push dx
	call counter
	pop dx
	;
first:	mov word [cs:pat-2],reprompt	; change text for future trials
	mov ah,9
	int 21h		; show prompt

	mov di,keybuf
keyloop:
	mov ah,7
	int 21h		; get key from stdin, no echo
	cmp al,13	; carriage return?
	jz checkkey
	cmp al,'a'	; boring case insensitivity for 7 bit ASCII
	jb upcase	; feel free to add NLS international upcasing
	cmp al,'z'
	ja upcase
	sub al,'a'-'A'
upcase:	mov ah,0	; keep string terminated
	mov [cs:di],ax
	inc di
	cmp di,keybuf+200	; arbitrary limit
	jz checkkey
	mov ah,6
	mov dl,'*'	; yes it is DL
	int 21h		; print a * to stdout
	jmp short keyloop

checkkey:
	mov dx,checkmsg
	mov ah,9
	int 21h		; show message
	mov si,81h	; command line
	mov di,keybuf
	cld
checkloop:
	lodsb
	cmp al,[cs:di]	; compare to user input
	jnz keywrong
	or al,al	; end?
	jz keyokay
	inc di
	jmp short checkloop

keywrong:
	mov ax,[cs:wrongcount]
	inc ax
	mov [cs:wrongcount],ax
	test ax,3	; every 4th time...
	jnz nobeep
beep:	mov ah,9
	mov dx,verywrong
	int 21h		; beep and complain
	;
	call melody
	;
	call clearscreen
	;
nobeep:	jmp nexttry

keyokay:
	push ds
	lds dx,[cs:old1b]
	mov ax,251bh
	int 21h		; restore int 1b
	lds dx,[cs:old23]
	mov ax,2523h
	int 21h		; restore int 23
	pop ds
	mov ax,4c00h
	int 21h		; exit with errorlevel 0


melody:	mov si,100h
meloop:	lodsw
	mov bx,ax	; "random" divisor
	mov cx,1	; 1/18th second
	;
	call tone
	;
	cmp si,endprog
	jbe meloop
	ret
	
tone:	; sound with divisor BX duration CX
	mov al,0b6h
	out 43h,al	; program timer
	jmp short a1
a1:	mov al,bl
	out 42h,al	; low byte
	mov al,bh
	jmp short a2
a2:	mov al,bh
	out 42h,al	; high byte
	in al,61h
	jmp short a3
a3:	or al,3
	out 61h,al	; enable speaker

	push ds
	mov ax,40h
	mov ds,ax
	sti
delay:	mov ax,[ds:6ch]
tick:	; hlt
	nop
	cmp ax,[ds:6ch]
	jz tick
	loop delay
	pop ds

	in al,61h
	and al,0fch	; disable speaker
	jmp x1
x1:	out 61h,al
	ret


clearscreen:
	push ds
	mov ax,40h
	mov ds,ax
	mov al,[ds:84h]	; only valid for EGA / newer, but who cares...
	mov ah,[ds:62h]	; page number
	pop ds
	push ax
	mov ah,0
	inc ax		; ax is now "rows on screen"
	mov cx,ax
clsloop:
	mov dx,crlfmsg
	mov ah,9
	int 21h		; go to next line
	loop clsloop
	pop ax
	mov bh,ah	; page number
	mov ah,2
	xor dx,dx
	int 10h		; move cursor to home position (upper left corner)
	ret


counter:
	mov ax,[cs:wrongcount]
	cmp ax,99
	jb normc
	mov ax,99
normc:	aam			; opcode d4 0a: ah = al/10, al=al mod 10.
	add ax,'00'		; convert to ASCII
	xchg al,ah		; AL = ten-digit AH = one-digit now...
	mov [cs:recount],ax	; update string
	ret

int1b:	iret	; ignore ctrl break
int23:	iret	; ignore ctrl break and ctrl c

reprompt	db 13,10,"Wrong password (#"
recount		db "99), try again!"
prompt		db 13,10,"Enter password to unlock: $"
checkmsg	db 13,10,"Checking password..."	; continued in crlfmsg
crlfmsg		db 13,10,"$"
verywrong	db 13,10,7,"Definitely wrong!",13,10,"$"
helpmsg	db "This program can only be stopped by (reset or) entering the right",13,10
	db "key - the one which you provide as command line argument...",13,10
	db "Case does not matter for A-Z. No protection against TSR hotkeys.",13,10
	db "$"
endprog:			; just a label
wrongcount	dw 0		; count of wrong entries
old1b		dd 0		; stores int 1b vector
old23		dd 0		; stores int 23 vector
keybuf		db "???"	; buffer to store user input

