program Midi_Player3; {$R-} {$A+} {$B-} {Stand...OFF}
uses WAVTAB2; {sound-FN}
{17.9.96 AuerSoft .. Updated 22.9.96 Player 5/97 uses WaveTbl (by AuerSoft) }
{11/97 nur noch ber WaveTbl/Wavtabsb-TSR und Wavtab/Wavtab2-Unit by EA}
{..keine PianoRoll mehr - nur noch ber wavtab Verwaltung}
{..V3 mit Minimalistenstatus aber Hllkurve ber i1C (i8 bei install gend.)}
const kilohertz=22; bufsize=8192; CON_EN=true; default_sust=TRUE;
    maxevtdauer=72; {in 1/48 Noten: 72 fr onetrack oder viel fr multitrack}
    {69=440Hz,A N*12=Cn, C2..C8 beliebt.. Mitte ca. 36}
    ffwd_multitrack1=false; ffwd:boolean=false;
    tconst:longint=4; {MidClk pro 1/48} {pro : 96/ 192 /240/384/480}
    DEFAULT_TEMPO_MS48=40; zeitfak=0.67; { SCHNELLER SPIELEN! }
    txtstart:word=1 shl 8; {bei Stat besser 18 shl 8} txtend:word=25 shl 8;
type chn=record	instr:byte; pitch:word; vol,expr:byte; sust:boolean; end;
var c:array [0..15] of chn;
    CURPOS:word absolute $40:$50; curbak:word;
    infi,outfi:file;  readbuf:array [0..bufsize-1] of byte;  readp:integer;
    tex,astr,bstr:string;  ente,DAMP,SUSTN,stat,xmode:boolean;
    trk,tempo,bpm, timepos,delta,tracklen,lang,langcount:longint;
    trackzahl,track,datacount,wert,TRANSPOSE:integer;
    event,subevent,evt,b,a,csel:byte;
    chnlmask:array [0..15] of boolean;

function keyget(waitkey,flushbuf:boolean):byte; begin
if flushbuf then while memw[$40:$1a]<>memw[$40:$1c] do inline($b8/>0/$16cd);
if waitkey then repeat until memw[$40:$1a]<>memw[$40:$1c];
if memw[$40:$1a]=memw[$40:$1c] then keyget:=0 else
 begin keyget:=mem[$40:memw[$40:$1a]]; inline($b8/>0/$16cd); end;
end;

procedure SHOWTEXT; forward;
function getby:byte; begin if readp>=bufsize then begin readp:=0;
 {$I-} blockread(infi,readbuf,bufsize shr 7); inoutres:=0; {$I+} end;
 getby:=readbuf[readp]; inc(readp); if trk=(tracklen+1) then begin
  if CON_EN then begin str(track,astr); str(tracklen,bstr);
   tex:='Track '+astr+' ('+bstr+'By): END missing!!! ... (Key)';
   SHOWTEXT; a:=keyget(true,true); end; WAVT_END; halt(1); end;
 inc(trk); end;

function getdelta:longint; var mache:longint; byt:byte; begin mache:=0;
 repeat byt:=getby; mache:=(mache shl  7 )+(byt and $7f);
 until byt<$80; {Max 4 Bytes ergeben so max 28 Bits} getdelta:=mache; end;

procedure gettext(lang:integer; var textstring:string);
var anzahl:integer; chrbuf:char; begin textstring:='';
for anzahl:=1 to lang do begin chrbuf:=chr(getby);
 if chrbuf<' ' then chrbuf:='';
 if textstring[0]<#60 then textstring:=textstring+chrbuf
  else textstring[60]:=''; end; end;

function getlong:longint; var machlang:longint; anzahl:integer;
begin machlang:=0; for anzahl:=1 to 4 do machlang:=(machlang shl  8 )+getby;
getlong:=machlang; end; {68000er-Format!}

function getword:word; var eins:word; begin eins:=getby shl 8 { ! };
 getword:=getby+eins; end; {68000er-Format!}

procedure SYS_RESET; var xcnt:word; begin
for xcnt:=0 to 15 do with c[xcnt] do begin instr:=0; pitch:=0;
 VOL:=100; EXPR:=127; SUST:=default_sust; end;
if xmode then begin
 for lang:=0 to 9 do chnlmask[lang]:=true; for lang:=10 to 15 do
  begin chnlmask[lang]:=false; CHAN_VOL(lang,0); end; end
else begin
 for lang:=10 to 15 do chnlmask[lang]:=true; for lang:=0 to 9 do
  begin chnlmask[lang]:=false; CHAN_VOL(lang,0); end; end;
DAMP:=false; SUSTN:=false; end;

procedure scrolltext; begin if CON_EN then; dec(CURPOS,$100);
 if stat then txtstart:=18 shl 8 else txtstart:=0;
 if curpos<txtstart then curpos:=txtstart;
 move(ptr($b800,(hi(txtstart)+1)*160)^,
 ptr($b800,hi(txtstart)*160)^,(hi(txtend)-hi(txtstart))*160); end;

procedure SHOWTEXT; {fix tex / ggf YScrollingWindow} var xstr:string; begin
 if CON_EN then begin CURPOS:=curbak;
 if CURPOS>=(txtend-$100) then scrolltext;
 if (tex<>'') and (csel<$ff) then
  begin xstr:='> '+tex; str(csel:2,tex); tex:=tex+xstr; end;
 WRITEln(tex); end; curbak:=CURPOS; end;

procedure ERROR; begin SYS_RESET; WAVT_QUIET; WAVT_END;
if CON_EN then begin str(track,astr);
 tex:='Fehler im Dateiformat in Track:'+astr; SHOWTEXT;
 str(trk,astr); str(tracklen,bstr);
 tex:='Databyte: '+astr+' of '+bstr+' (Key for Quit)'; SHOWTEXT;
 a:=keyget(true,true); end; halt(1); end;

begin {MAIN} tracklen:=-1; trk:=1; track:=-1; csel:=$ff;
stat:=false; xmode:=true;
WAVT_CUTOFF:=FALSE; {sonst wre Sustain off = Stumm}
if CON_EN then begin txtend:=mem[$40:$84] shl 8;
 WRITEln('Los mit Taste...'); a:=keyget(true,true);
 for lang:=1 to 2*hi(txtend) do WRITEln(output,' '); CURPOS:=0;
 WRITEln('MIDI Anzeige und Ausgabe, Tracks ggf nacheinander)');
 WRITEln('By AuerSoft 9/96-11/97');
 WRITEln('ESC Skip to EOT / T TechInfo-T     / + FastFwd-T');
 WRITEln('P bei Panik     / S Sustainforce-T / - Damper-T');
 WRITEln('Hexziffer fr Kanalmute-T ("-T"=Toggle) ');
 WRITEln('X fr Umschaltung nach Base-Level und zurck');
 WRITEln('Start mit MIDPLAY3 midifile[.mid]'); end;
 {Paramstr(0) ist EXE selbst}
 tex:=paramstr(1); if tex[ord(tex[0])-3]<>'.' then tex:=tex+'.mid';
 if CON_EN then WRITEln('File: ',tex,'');
 assign(infi,tex); {$I-} reset(infi); if ioresult>0 then
  begin WRITEln('File ',tex,' not found!'); ERROR; end; {$I+}
 readp:=bufsize;
{HEADER}
gettext(4,tex); if tex<>'MThd' then ERROR;
lang:=getlong; if lang<>6 then ERROR;
wert:=getword; if wert>2 then ERROR;
if wert=0 then begin trackzahl:=1; wert:=getword and 0; end else
 trackzahl:=getword; if CON_EN then WRITEln('Tracks: ',trackzahl);
wert:=getword; if wert>=$8000 then begin
 if CON_EN then WRITEln('SMPTE-Timing: Frames per Second=',
  255-(hi(wert) xor $ff),' Auflsung=',lo(wert));
 end else begin
  if CON_EN then WRITEln('Delta Time Ticks (DTT) pro  Note: ',wert);
  if wert>=(48 shr 2) then tconst:=wert div (48 shr 2); {1/48 Note} end;
NOTE_INIT(ROUND(zeitfak*DEFAULT_TEMPO_MS48){ms/48tel},kilohertz);
SYS_RESET; WAVT_QUIET;
if CON_EN then begin curbak:=txtstart; tex:='';
 for lang:=1 to 2*hi(txtend) do SHOWTEXT; end;

{TRACK}		{ab hier nur noch mit Showtext}
for track:=1 to trackzahl do BEGIN trk:=1; csel:=$ff;
if (track=1) and (trackzahl>1) and ffwd_multitrack1 then ffwd:=true;
if (track=2) and ffwd_multitrack1 then ffwd:=false;
tracklen:=-1; gettext(4,tex); if tex<>'MTrk' then ERROR;
tracklen:=getlong;
if CON_EN then begin str(track,astr); str(tracklen,bstr); tex:='Track '+astr+
 ' => '+bstr+' Bytes inklusive Timinginfo.'; SHOWTEXT; end;
trk:=1; timepos:=0; SYS_RESET; WAVT_QUIET; ente:=false;
{DATA...}
repeat csel:=$ff;
  if CON_EN then begin a:=keyget(false,false); case upcase(chr(a)) of
   #27: begin ente:=true; tex:='Skipped to EndOfTrack'; SHOWTEXT; end;
   '+': ffwd:=not(ffwd);
   'P': begin tex:='Panik!!!'; SHOWTEXT; WAVT_QUIET; end;
   '-': begin DAMP:=not(DAMP); if DAMP then SUSTN:=false; end;
   'S': begin SUSTN:=not(SUSTN); if SUSTN then DAMP:=false; end;
   '0'..'9': begin lang:=a-ord('0'); chnlmask[lang]:=not(chnlmask[lang]);
     for lang:=0 to 9 do if not(chnlmask[lang]) then CHAN_VOL(lang,0); end;
   'A'..'F': begin lang:=10+ord(upcase(chr(a)))-ord('A');
     chnlmask[lang]:=not(chnlmask[lang]);
     for lang:=10 to 15 do if not(chnlmask[lang]) then CHAN_VOL(lang,0); end;
   'X': begin xmode:=not(xmode); if xmode then begin
     for lang:=0 to 9 do chnlmask[lang]:=true; for lang:=10 to 15 do
      begin chnlmask[lang]:=false; CHAN_VOL(lang,0); end; end
     else begin
     for lang:=10 to 15 do chnlmask[lang]:=true; for lang:=0 to 9 do
      begin chnlmask[lang]:=false; CHAN_VOL(lang,0); end; end; end;
   'T': begin stat:=not(stat); FILLCHAR(ptr($b800,0)^,160*18,#0); end;
  end; {case}
  if upcase(chr(a)) IN ['-','S','+','0'..'9','A'..'F','X'] then begin
   str(byte(DAMP),astr); str(byte(SUSTN),bstr);
   tex:='Damp/Sustain='+astr+'/'+bstr; if DAMP or SUSTN then
    tex:=tex+' (Sustain): [' else tex:=tex+' Sustain:   [';
    for lang:=0 to 15 do if c[lang].sust then tex:=tex+'1' else tex:=tex+'0';
    tex:=tex+'], Enable: [';  for lang:=0 to 15 do
     if chnlmask[lang] then tex:=tex+'#' else tex:=tex+'-';
    tex:=tex+']'; if ffwd then tex:=tex+' FFWD'; SHOWTEXT; end;
  end;
if not(ente) then BEGIN
DELTA:=getdelta;
if DELTA>0 then begin inc(timepos,DELTA); lang:=DELTA div tconst;
  if (lang<maxevtdauer) and not(ffwd) then
   for langcount:=0 to lang do NOTE_WAIT; {Dauer 1/48 Note}
  if ffwd then NOTE_WAIT; {alle 1/48 lang}
  if CON_EN and STAT then WAVT_STAT(true); end;
{...NOTE}
evt:=getby; if evt>=$80 then EVENT:=evt; {'PACK' ! } csel:=EVENT and $f;
if EVENT<$f0 then begin event:=(event shr 4) and 7;
 if evt<$80 then a:=evt else a:=getby; {'PACK'} if a>$7f then ERROR;
 if (EVENT {s.o.: shr 4} <4) or (EVENT {s.o.: shr 4} >5) then
 begin b:=getby; if b>$7f then ERROR; end; str(a,astr); str(b,bstr);
 if EVENT {s.o.: shr 4} <3 then begin
  TRANSPOSE:=transposetab[ chnlinst[ csel ] ]+a;
  if TRANSPOSE>$7e then TRANSPOSE:=$7e;
  if TRANSPOSE<0 then TRANSPOSE:=0; a:=TRANSPOSE;
  lang:=b; lang:=(lang*c[csel].VOL*c[csel].EXPR) shr (14-1); b:=lo(lang);
  end;
 with c[csel] do case EVENT {s.o.: shr 4} of
0: NOTE_OFF(csel{chnl},a{note},b{laut});                 {NOTE OFF}
1: if chnlmask[csel] then begin                          {NOTE ON}
   if not(SUSTN) and (DAMP or not(SUST)) then a:=a or $80; {msb=key released}
   if b=0 then NOTE_OFF(csel{chnl},a{note},b{laut}) {alternate note off} else
    NOTE_ON(csel{chnl},a{note},b{laut}); end;
2: begin NOTE_AMP(csel{chnl},a{note},b{laut}); end;      {AFTERTOUCH}
3: begin tex:='Control['; tex:=tex+astr+']:='+bstr;
   if not (a in [7,10,11,64]) then SHOWTEXT;
   case a of 120,123: {sounds/all notes off} WAVT_QUIET; {CONTROL CHG}
   121: {controller reset} SYS_RESET; 64: {sustain} SUST:=b>63; {=> note on}
   7: {volume} begin VOL:=b; CHAN_VOL(csel{chnl},b+b{laut}); end;
   11: {expression} begin EXPR:=b; CHAN_VOL(csel{chnl},b+b{laut}); end;
   end; {case}
   { Und:... 0 Bank 32 SubBank (32+n Sub...) 1 Modulation/Detune 10 Pan
     6/38 Data Entry 91/93 AWEFX1/2Depth 98..101 NRPL NRPH RPL RPH
     bei SB AWE 32 untersttzte Controller - Mode fix Poly on/Omni off
     Fr Aftertouch nur Channel Aftertouch untersttzt } end;
4: begin instr:=a; tex:='Instrument:='+astr; SHOWTEXT;   {PROG CHG}
   NOTE_INS(csel{chnl},instr); {CHAN_VOL(csel,0);} end;
5: CHAN_VOL(csel{chnl},a+a{laut});                       {AFTERTOUCH}
6: begin pitch:=(a shl 7)+b; str(pitch,astr); tex:='(Pitchvalue):='+astr;
    if chnlmask[csel] then SHOWTEXT; end;                {PITCHBEND ##ign.##}
end; {case} end; {<$f0} csel:=99;
{...SPEZIAL}
if (EVENT>$f0) and (EVENT<$ff) then
 case EVENT of {Sonderevents $f1..$fe} {ff SysReset, nicht in Files}
  {f1,f4,f5,f9,fd: undefined  f6:tune request  fe: active sensing}
 $f2: begin a:=getby; {hi} b:=getby; {lo} end; {songpos}
 $f3: b:=getby; {songsel} { start/cont/stop sequencer: fa,fb,fc }
 $f7: begin tex:='?EOX'; SHOWTEXT; ERROR; end;            {EOX}
 $f8: begin tex:='Clock'; SHOWTEXT; end;                  {CLK}
end; {case}
if EVENT=$f0 then begin {Sys_Ex, Lngeninfo Bonus in File!} lang:=getdelta;
 str(lang,astr); tex:='System_Exclusive!!! '+astr+' By'; SHOWTEXT;
 tex:=''; repeat b:=getby; dec(lang);
  if b>31 then tex:=tex+chr(b) else tex:=tex+'.';         {SYSEXDATA}
 until b=$f7; {EOX - darum nicht vorher bekannte Lnge} SHOWTEXT;
 if lang<>0 then
  begin str(lang,astr); tex:=astr+'By zuwenig!'; SHOWTEXT; ERROR; end;
 end;
if EVENT=$ff then begin {Metaevent, wie auch TimeInfo nur in File}
 subevent:=getby; str(subevent,astr); tex:='Meta_Event: '+astr;
 lang:=getdelta; case subevent of
  0:begin if lang<>2 then ERROR; wert:=getword;
   str(wert,astr); tex:=tex+' !Sequence: '+astr; end;     {INFO SEQ_NO}
  1..$f: begin gettext(lang,astr); tex:=tex+' !'+astr+'';
   {ASCII-Events: Text,Copyright,Trackname, Instr_Name,Songtext,
    Markertext,Cuepointtext, 8 reservierte} end;          {ASCII}
  8..$f: tex:=tex+' ?Reserved';
  $20: begin if lang<>1 then ERROR; b:=getby; end; {ChnNr(info)}
  $2f: begin if lang>0 then ERROR;                        {END}
   tex:=tex+' TRACKENDE_!!!'; ente:=true; end;
  $51: begin if lang<>3 then ERROR;                       {TEMPO s/Note}
   lang:=getword; b:=getby; tempo:=(lang shl 8 {???} )+b;
   bpm:=60000000 div tempo; {BPM} str(bpm,astr); tex:=tex+' Tempo BPM='+astr;
   NOTE_TEMPO( round(zeitfak*(tempo div (1000*(48 shr 2)) ){ms/48.} )); end;
  $54: begin if lang<>5 then ERROR; {h,m,s,f,cf} tex:=tex+' !SMPTE=';
   str(getby:3,astr); str(getby:2,bstr); tex:=tex+astr+':'+bstr+':';
   str(getby:2,astr); str(getby:2,bstr); tex:=tex+astr+','+bstr;
   str(getby:2,astr); tex:=tex+astr; end;                 {SMPTE}
  $58: begin if lang<>4 then ERROR; gettext(lang,astr);   {INFO TAKT} end;
   {By A..D => Takt A/(1 shl B),  Clk/Met C,  32./24Clk D}
  $7f: begin gettext(lang,astr);
   tex:=tex+' Seq_Data! '+astr; end;                      {SEQUENCER DATA}
  else gettext(lang,astr); {unknown} end; {case Meta}
 SHOWTEXT; end;
{...STANDARD}
end; { not(ente) } until ente; WAVT_QUIET;
 if trk<=tracklen then begin str(tracklen+1-trk,astr);
  tex:=astr+'By skipped (by ESC or ?Error)'; if CON_EN then SHOWTEXT;
  while trk<=tracklen do a:=getby; end; {## bei Track skip ##}
ente:=false;
end; {Track}
close(infi); WAVT_END; end.
